/*------------------------------------------------------------------------------*
 * File Name: FitNL.h															*
 * Creation: YuI 08/13/2004													    *
 * Purpose: Origin C header	for NLFitterOperation class 						*
 * Copyright (c) OriginLab Corp.	2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 1/26/2005 CUSTOM_TABLE_TO_GRAPH											*
 *	DSC 2/4/05 NLFIT_THEME_DROP_LIST											*
 *	CPY 8/5/05 rename file-class to FitNL										*
 *	ML 11/2/2005 QA70-8135 MISSING_AND_MASKED_DATA_FOR_XYZ						*
 *	ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION					*
 *	ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION							*
 *	ML 5/15/2006 SPECIAL_NLFITS_CUSTOM_TABLE									*
 *	ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY								*
 *	ML 8/16/2006 FITNL_GETTING_FINDXYYX_SECTION_NAME							*
 *	ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL							*
 *	ML 10/2/2006 NLFIT_CURVES_CLEANUP											*
 *	CPY 11/20/06 CANNOT_COMPILE_IRIS_JOE_CODE									*
 *	ML 12/18/2006 FITWORKAREA_MISSING_ERROR										*
 *	ML 12/18/2006 CALLING_OPERATION_FROM_OC_LT									*
 *	Arvin/Cheney 03/26/07 QA70-9527 SUPPORT_SETTING_PARAMS_FROM_OC_LT			*
 *	Arvin 03/27/07 QA70-9532 CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX	*
 *	Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG							*
 *	Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING
 *	Cheney 2007-4-2 ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA	*
 *	Cheney 2007-4-2 IF_SHARE_PARAMETERS_ADD_HINTS_IN_FOOTNOTE					*
 *	Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX					*
 *	Cheney 2007-4-4 ADD_FOOTNOTE_FOR_FIT_STATUS_AS_LARRY_SUGGEST				*
 *	Cheney 2007-4-4 SHOW_LB_UB_IN_REPORT_SHEET									*
 *	Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH						*
 *	Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON				*
 *	Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA*
 *	Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE			*
 *	Arvin 04/24/07 v8.0607 SURFACE_FIT_NEED_UPDATE_TROPERATION_BEFORE_RUNNING_CHANGE_PARAM_AND_RECALCULATE
 *	Cheney 2007-4-24 CLEAN_UP_FDF_TREE_LOAD										*
 *	Cheney 2007-6-19 ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT		*
 *	Cheney 2007-7-16 SHOULD_SHARE_CODE_BETWEEN_NLFITSPLITTER_AND_FITNL_ABOUT_AUTOINIT_AND_LINEAR_CONSTRAINT
 *	Cheney 2007-7-17 SHOULD_UPDATE_SPECI_INFO_WHEN_THEME_LOAD_OR_FUNC_CHANGE_IF_IS_SPECI_FIT
 *	Cheney 2007-7-30 ADD_NEW_FUNC_TO_SUPPORT_PFM_LOAD_FDF						*
 *	Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME								*
 *	Cheney 2007-8-30 QA70-10290-sug4 FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT	*
 *	Cheney 2007-9-6 FINDZ_NODE_SHOULD_PREPARED_WHEN_CHANGE_PARAM				*
 *	Cheney/Arvin 2007-9-10 XOP_NEED_SUPPORT_PFM									*
 *	Cheney 2007-9-13 SUPPORT_FIT_MATRIX_FROM_GRAPH								*
 *	Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT*
 *	Jasmine 09/30/07 QA70-10462 CHECK_REPLACE_USER_FITTING_FUNCTION_TO_GROUP_ONE*
 *	Jasmine 10/17/07 MISSING_SIGN_DIGITES										*
 *	Arvin 11/20/07 QA70-10708 CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
 *	Hong 01/22/08 QA80-10929 LTNL_ACCESS_FITSESSION_PONTER						*
 *	Hong 01/24/08 QA80-10929 LT_NLFIT_SUPPORT_SOUURCE_GRAPHPAGE_PREVIEW			*
 *	Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit									*
 *	Hong 02/01/08 v8.0798 FIX_CONTANTENATE_FIT_FAIL_WORK						*
 *	Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
 *	Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS		*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Jasmine 04/16/08 MOVE_UPDATE_MODEL_CODES_IN_FITNL_CLASS						*
 *	Folger 08/18/08 QA80-12036 FIX_BOUNDS_MISSING_IN_REPORT_SHEET_FOR_REPLICA_FIT
 *  Iris 8/15/2008 QA80-12025 TO_FIX_DOUBLE_MEANING_FOR_nOption_IN_FITNL		*
 *	Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS									*
 *	Hong 09/03/08 QA80-12130 NLFIT_SESSION_SUPPORT_SEPARATE_FIT					*
 *	Folger 10/14/08 WRONG_NLF_CURVES_CLASS_IN_PA_MAKES_WRONG_REPORT				*
 *	Sophy 11/4/2008 RESET_FDF_ON_INIT_SESSION_LEAD_TO_RESET_AUTORUNINITPARAMS	*
 *	Folger 11/06/08 QA80-12536 v8.0966 LOWER_AND_UPPER_BOUNDS_FAILS_TO_REPORT_IN_PA
 *	Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET	*
 *	Folger 11/28/08 v8.0980 CLEAN_UP_REPLICA_FITTING_JUDGEMENT					*
 *	Folger 12/11/08 QA80-12766 v8.0985 SIGNIFICANT_DIGITS_FAILS_TO_APPLY_TO_NLSF_FITTING_REPORT
 *	Jack 12/19/2008 QA80-12329 MULTI_INDEP_DEPS_BAND_CALCULATION				*
 *	Folger 12/22/08 QA80-12766-P2 v8.0990 SIGNIFICANT_DIGITS_NOT_WORKING_FOR_MULTIPLE_DATASETS_REPORT
 *	Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
 *	Folger 12/23/08 v8.0990 FAST_ACCESS_ABOUT_GETTING_PARAMETER_NAMES_IN_NLFIT_AND_PA
 *	Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE	*
 *	Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
 *  Iris 7/29/2009 QA80-14029 FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM
 *	Folger 07/31/09 QA80-13998 DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS		*
 *	Kyle 08/10/2009 QA80-14077 ADD_PARAMETER_UNIT_TO_FITTING_REPORT				*
 *	Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING	*
 *	Folger 09/25/09 LINEAR_CONSTRAINTS_NOT_WORK_WHEN_RUN_PA_IN_SCRIPT_MODE		*
 *	Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
 *	Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU				*
 *	Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN			*
 *------------------------------------------------------------------------------*/

#ifndef		_NLFITTEROPERATION_H
#define		_NLFITTEROPERATION_H

///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG	
//move it to NLFitSession.h
/////Arvin 03/27/07 QA70-9532 CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX
//typedef enum tagNLFITTYPE
//{
	//NLFIT_GENERAL_XY_FITTING,
	//NLFIT_XYZ_FITTING,
	//NLFIT_MATRIX_FITTING,
//}tagNLFITTYPE;
/////END CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX
///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG

class	OC_REGISTERED	FitNL	:	public	FitterOperation
{
public:
	FitNL();
	~FitNL();
	
public:
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//virtual bool	Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true);
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	
	bool 	UpdateModelNote(TreeNode& trTable, const TreeNode& trOperation);		///Jasmine 04/16/08 MOVE_UPDATE_MODEL_CODES_IN_FITNL_CLASS
	virtual bool 	UpdateNumParamsDatasetsNote(TreeNode& trTable, int nTotalNumData, const TreeNode& trOperation); /// Iris 8/14/2008 QA80-12017-S2 ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
	
	///Arvin 10/27/06 FITTING_FUNCTION_MODEL_IN_REPORT
	string GetResultModel(const TreeNode& trOperation);
	///end FITTING_FUNCTION_MODEL_IN_REPORT
	//virtual 
	string GetResultDescription(const TreeNode& trOperation, bool bLong);// = true)
	//virtual
	DWORD	GetDataRules(const TreeNode& trOperation, bool bIgnoreCombineInfo = false);  /// Iris 6/07/05 NLSF_SUPPORT_XYZ_DATA

	//----CPY 11/10/06 NLFIT_NEW_CODE_RUNTIME_ERR_ON_CANCEL_BUTTON
	//virtual
	///------ Folger 07/31/09 QA80-13998 DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS
	//void	DestroyInternal();
	void	DestroyInternal(BOOL bDeleteOutputs = FALSE);
	///------ End DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS
	//virtual 
	BOOL	OnKeepOpAfterExecute();
	//----
	
	/// ML 12/18/2006 CALLING_OPERATION_FROM_OC_LT
	// virtual
	//BOOL	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, LPCSTR lpcszX, LPCSTR lpcszY);
	///Arvin 03/27/07 QA70-9532 CALLING_SURFACE_FIT_FROM_OC_LT
	//BOOL	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, XYRange &xyrng, LPCSTR lpcszStr1 = NULL, LPCSTR lpcszStr2 = NULL);
	///Arvin 01/29/08 SHOULD_NOT_ADD_USER_PARAM_SETTING_TREE_IN_CLASS_LT_NLFit
	//int	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, DataRange &dr, LPCSTR lpcszStr1 = NULL, LPCSTR lpcszStr2 = NULL);
	///------- Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
	//int	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, DataRange &dr, LPCSTR lpcszStr1 = NULL, LPCSTR lpcszStr2 = NULL, bool bNeedUserParamSetting = true);
	int	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, DataRange &dr, LPCSTR lpcszStr1 = NULL, LPCSTR lpcszStr2 = NULL, bool bNeedUserParamSetting = true, TreeNode& trOriginalInput = NULL);
	///------- End COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
	///end SHOULD_NOT_ADD_USER_PARAM_SETTING_TREE_IN_CLASS_LT_NLFit
	///end CALLING_SURFACE_FIT_FROM_OC_LT
	/// end CALLING_OPERATION_FROM_OC_LT
	
	///Arvin 03/27/07 QA70-9532 CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX
	int 	CheckMakeFitterInputDataNode(TreeNode &trOp, TreeNode &trInput, DataRange& dr, LPCSTR lpcszCateg, LPCSTR lpcszInputTagName = NULL);
	int 	GetFitType(TreeNode& trOp);
	///end CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX
	
	bool 	PrepareFitTypeFromInput(TreeNode& trOp, DataRange& dr, LPCSTR lpcszCateg); /// Hong 02/01/08 v8.0798 FIX_CONTANTENATE_FIT_FAIL_WORK
	
	//Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT
	int OnInitOperationTreeFromOCLT(TreeNode &trOp, TreeNode& trOCLT, bool bInitTree = true);
	///end XOP_NEED_SUPPORT_NLFIT

	///Arvin 04/17/07 v8.0602 FIT_MATRIX_HISTOGRAM_PLOT
	///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	//int PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex);
	/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	//int PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph = false);
	///Arvin 08/15/07 QA70-10212-P3 ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
	//int PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph = false, bool bCheckIfHasPlot = false);
	int PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph = false, bool bCheckIfHasPlot = false, int* pStartPlotIndex = NULL);
	///end ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
	///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	///end FIT_MATRIX_HISTOGRAM_PLOT

	///Arvin/Cheney 03/26/07 QA70-9527 SUPPORT_SETTING_PARAMS_FROM_OC_LT
	bool 	AddParamsInfoToOperationTree(TreeNode &trOp, LPCSTR lpcszFunName, LPCSTR lpcszCateg, string strTagName = "Parameters");
	///end  SUPPORT_SETTING_PARAMS_FROM_OC_LT
	
	///Joseph 04/02/07 ADD_NLSF_ERR_MSG_EVENT
	PEVENT_GETN	GetNewEventFunction();
	///End ADD_NLSF_ERR_MSG_EVENT
	///Cheney 2007-6-19 ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	bool GetFitCurve(TreeNode& trOp, vector& vx, vector& vy, int& nPeaks, int nIndex = 0);
	///end ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	
	/// Hong 01/22/08 QA80-10929 LTNL_ACCESS_FITSESSION_PONTER
	// virtual
	void* GetSessionPtr()
	{
		return m_pFitSession;
	}
	/// end LTNL_ACCESS_FITSESSION_PONTER
	
	///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
	//virtual
	TreeNode	GetInputDataNode( const TreeNode& trGUI );
	//virtual
	TreeNode	GetOutputNode( const TreeNode& trGUI );
	///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
	
	///---Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS
	void		SetLTTreeSetting(DWORD dwOption);
	///---END NLFIT_LABTALK_TREE_ACCESS
	
	///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION	
#ifdef SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	//bool   ConstructParamBranchByThemeTree(const TreeNode& trTheme, TreeNode& trOp, string* pstrSelectedTheme);
	/*
	bool ConstructParamBranchByThemeTree(const TreeNode& trTheme, TreeNode& trGUI);
	bool IsParamInThemeFilter(TreeNode& trGUI);
	virtual bool ApplyThemeFilterSetting(TreeNode& trGUI, const TreeNode& trThemeFilter);
	bool ApplyFDF(TreeNode& trGUI);
	*/
	virtual bool ApplyTheme(LPCSTR lpcszClassName, TreeNode& trGUI, LPCSTR lpcszThemeName, bool bLoadFactDefault = true);
	///---END QA80-11371 THEME_SAVING_OPTIONS
#endif
	///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION

protected:	
	/// Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
	//virtual 
	int		InitFromSelection(TreeNode &trOperation);
	/// end HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
	
	//------ Folger 12/11/08 QA80-12766 v8.0985 SIGNIFICANT_DIGITS_FAILS_TO_APPLY_TO_NLSF_FITTING_REPORT
	/// virtual
	///------ Folger 12/22/08 QA80-12766-P2 v8.0990 SIGNIFICANT_DIGITS_NOT_WORKING_FOR_MULTIPLE_DATASETS_REPORT
	//int	GetSignDigitsArray(vector<int>& vnSignDigits);
	int	GetSignDigitsArray(vector<int>& vnSignDigits, int nDataIndex = 0);
	///------ End SIGNIFICANT_DIGITS_NOT_WORKING_FOR_MULTIPLE_DATASETS_REPORT
	//------ End SIGNIFICANT_DIGITS_FAILS_TO_APPLY_TO_NLSF_FITTING_REPORT
	
	///Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	//BOOL 	GetExecuteCtrl(const TreeNode& trFitWorkArea, DWORD& dwExecCntrl);
	//virtual
	BOOL 	GetExecuteCtrl(const TreeNode& trOperation, DWORD& dwExecCntrl);
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	///end GENERATE_REPORT_FOR_LT_NLFit
	
	/// Iris 10/28/2009 QA81-14546 CHANGE_GUI_REPORT_TABLE_LABEL
	/*
	//virtual	
	string	GetReportTableGUIName(TreeNode& trGUI);
	*/
	///end CHANGE_GUI_REPORT_TABLE_LABEL

	/// Iris 3/12/2009 CLEANUP_UpdateDataModeNode_CODES
	/*
	///Arvin 01/03/08 SHOULD_ALWAYS_SHOW_DATA_MODE_WHEN_FIT_MULTI_DATASETS as cp said
	void UpdateDataModeNode(TreeNode& trOp, int nDataMode, int nTotalNumData);
	///end SHOULD_ALWAYS_SHOW_DATA_MODE_WHEN_FIT_MULTI_DATASETS
	*/
	//virtual
	string GetFitModeCombo();
	///end 	CLEANUP_UpdateDataModeNode_CODES
	
	/// Iris 02/27/2007 v8.0571 REMOVE_GLOBAL_FIT_DATA_MODE_IN_LR_PR_MR, INPUTDATA_NLFIT_CURVES not worked, so commented it temp
	//virtual 
	int GetDataMode() { return INPUTDATA_NLFIT_CURVES; }
	///end REMOVE_GLOBAL_FIT_DATA_MODE_IN_LR_PR_MR

	/// ML 11/10/2006 NLFIT_MODAL_CLEANUP
	///Sophy 11/4/2008 RESET_FDF_ON_INIT_SESSION_LEAD_TO_RESET_AUTORUNINITPARAMS
	//void	CleanupFitSession(LPCSTR lpcszMsg);
	void	CleanupFitSession(LPCSTR lpcszMsg, bool bResetFDF = true );
	///end RESET_FDF_ON_INIT_SESSION_LEAD_TO_RESET_AUTORUNINITPARAMS
	// virtual
	BOOL	PostExecute(int nExeMode, BOOL bExeRet);
	/// end NLFIT_MODAL_CLEANUP

	//virtual
	//----------- Iris 11/20/2008 v8.0975d QA80-12591-P4 REMOVE_LOG_DATA_TYPE_WHEN_DATA_FROM_MATRIX
	//void FilterTreeForGUI(TreeNode& trOp) {} // do nothing for NLfit
	void FilterTreeForGUI(TreeNode& trOp);
	//-----------
	
	/// ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION
	/////DSC 2/4/05 NLFIT_THEME_DROP_LIST
	//// Virtual 
	//string GetClassName() {return "FitNL";} //STR_NLF_BASE_CLASS
	/////end NLFIT_THEME_DROP_LIST
	string	GetClassName();
	/// end INVOKING_OPERATION_FROM_XFUNCTION
	
	///Arvin 12/29/06 MOVE_TO_ANALYSIS_UTILS
	///Arvin 11/03/06 SET_W_AS_ED_OF_DATARANGE_AND_PLOT_ERROR_BAR
	//int plotInputDataWithErrorBar(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL);
	///end SET_W_AS_ED_OF_DATARANGE_AND_PLOT_ERROR_BAR
	///END MOVE_TO_ANALYSIS_UTILS
	
	/// ML 5/15/2006 SPECIAL_NLFITS_CUSTOM_TABLE
	/// ML 10/2/2006 NLFIT_CURVES_CLEANUP
	// virtual
	int	PlotInputData(DataRange &rngInput, const TreeNode& trOp, GraphLayer& gl, int index, int nPlotType = IDM_PLOT_SCATTER, int iIndep = 0, int iDep = 0);
	/// end NLFIT_CURVES_CLEANUP
	

	/// end SPECIAL_NLFITS_CUSTOM_TABLE
	
	// virtual
	string 	GetResultBookName(TreeNode& trGUI); /// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	//virtual 
	string 	GetResultSheetName(TreeNode& trGUI);
	//virtual
	string	GetResultCurveSheetFullName(TreeNode& trOperation, int nIndex = 0, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);	///Sophy 6/3/2008 FIX_GET_OPERATION_TREE_FAILURE

	/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
	// virtual
	string		getXYorYXFormulaSectionName(bool bYfromX)
	{
		/// ML 8/16/2006 FITNL_GETTING_FINDXYYX_SECTION_NAME
		//if ( bYfromX )
		//	return "FitNL_YfromX";
		//else
		//	return "FitNL_XfromY";
		return FitterOperation::getXYorYXFormulaSectionName(bYfromX);
		/// end FITNL_GETTING_FINDXYYX_SECTION_NAME
	}
	/// end CUSTOM_TABLES_FOR_FIND_XY
	
	//--- CPY 8/18/04
	//virtual
	BOOL Construct(TreeNode& trOp, int nOption = 0);
	//virtual 
	//string	GetResultSheetName() {return "NLFit";}	/// Iris 2/06/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT move to FitterOperation			
	/// ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION
	////virtual 
	//string GetAnalysisName(int nOption) {return "NL Fit";}
	//virtual 
	string GetAnalysisName(int nOption);
	//virtual 
	BOOL	SetInfoFromXF(int nOption, LPCSTR lpcszClass, StringArray &saOptions, StringArray &saNames, LPCSTR lpcszStr2 = NULL);
	//virtual 
	int		GetOptionIndex(const TreeNode& trGUI);
	/// end INVOKING_OPERATION_FROM_XFUNCTION
	
	//virtual
	void ConstructAddBeforeQuantitiesToCompute(TreeNode& trGUI);	
	//virtual 
	void ConstructAddCommonBottom(TreeNode& trGUI);
	//----
	///Jasmine 09/30/07 QA70-10462 CHECK_REPLACE_USER_FITTING_FUNCTION_TO_GROUP_ONE
	// virtual
	/// YuI 06/06/08 QA70-11619 MORE_CLEAR_WORKSHEET_PROBLEM
	//	void	GUIOnUpdateTreeBeforeRunning(TreeNode &trGUINew, TreeNode &trGUIOriginal);
	///---Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
	//void	GUIOnUpdateTreeBeforeRunning(TreeNode &trGUINew, TreeNode &trGUIOriginal, TreeNode& trOperation);
	void	GUIOnUpdateTreeBeforeRunning(const MultipleVersion& mvOld, TreeNode &trGUINew, TreeNode &trGUIOriginal, TreeNode& trOperation);
	///---END QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
	/// end MORE_CLEAR_WORKSHEET_PROBLEM
	///End CHECK_REPLACE_USER_FITTING_FUNCTION_TO_GROUP_ONE
	//virtual 
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//BOOL	OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true);
	///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	//BOOL	OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true, bool bFromHotkey = false);
	BOOL	OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true, DWORD dwExeCtrl = 0, DWORD dwParam = 0);
	///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	
	virtual bool GetCategoryFuncNames(TreeNode& trOperation, string& strCategory, string& strFunction, vector<string>& vsFilterList);
	
	//virtual BOOL	executeWithRange();
	virtual bool	CalcMultiData(TreeNode& trOp, DataRange& dr, int &nNumData, int nExeMode, DWORD dwExecCntrl = 0);
	
	string	GetFDFFileName(TreeNode& trOp);
	//virtual
	bool	ShowDlg(TreeNode& trOperation, BOOL bChangeParams); 
	//call in GetParameters
	///------ Folger 12/23/08 v8.0990 FAST_ACCESS_ABOUT_GETTING_PARAMETER_NAMES_IN_NLFIT_AND_PA
	////int		GetParametersInFunctions(vector<string> &vstrParameterNames, int nNumberFunction, bool bIncNumPostfix);
	//virtual int		GetParametersInFunctions(vector<string> &vstrParameterNames, int nNumberFunction, bool bIncNumPostfix);///Sandy 2008-12-22 virtual for fitpeak
	///------ End FAST_ACCESS_ABOUT_GETTING_PARAMETER_NAMES_IN_NLFIT_AND_PA
	//virtual 
	int		GetParameters(TreeNode &trOp, int index = 0, vector<string> &vstrParameterNames = NULL, bool bIncNumPostfix = false, bool bIncDerivedParams = false, vector<bool>& vbIsDerived = NULL);

	///Kyle 08/10/2009 QA80-14077 ADD_PARAMETER_UNIT_TO_FITTING_REPORT
	// virtual
	int		GetParamUnits(TreeNode& trOp, int index = 0, vector<string> &vstrParameterUnits = NULL, bool bIncDerivedUnits = false, vector<bool>& vbIsDerived = NULL);
	///End ADD_PARAMETER_UNIT_TO_FITTING_REPORT

	//virtual
	void	FilterStatsReport(TreeNode& trOp);  /// Iris 6/04/05 FILTER_STATS_REPORT
	
	//virtual
	void	FilterFittingGUI(TreeNode& trOp);   /// Iris 6/04/05 ADD_FILTER_FITTING_GUI

	/// ML 11/2/2005 QA70-8135 MISSING_AND_MASKED_DATA_FOR_XYZ
	// virtual
	///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	//bool	HasZ(TreeNode& trOp);
	bool HasZ(TreeNode& trOp, bool *pbHasXIndep = NULL, bool *pbHesYIndep = NULL);
	///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	/// end QA70-MISSING_AND_MASKED_DATA_FOR_XYZ
	
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	int 	GetNumX(TreeNode& trOp); 
	//end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	
	///Arvin 10/25/06 ORIGINAL_DATA_SCATTER_UNSHOW
	int 	GetNumY(TreeNode& trOp);
	///end ORIGINAL_DATA_SCATTER_UNSHOW
	
	///Iris 4/21/05 MAKEFITY_SUPPORT_MULTI_REGRESSION
	////virtual bool MakeFitX(int index, const string &strDataLabel, const vector& vX, vector& vFitX, TreeNode trOp, const FitResultCurveOptions& fitOptions);
	//virtual bool MakeFitY(int index, TreeNode &trOp, const vector& vFitX, vector& vFitY, FitParameter* psFitParameter);
	//virtual 
	bool MakeFitY(int index, TreeNode &trOp, const vector& vFitX, vector& vFitY, FitParameter* psFitParameter, const matrix& mMultiIndep = NULL, int nPeak = 0);
	///end MAKEFITY_SUPPORT_MULTI_REGRESSION
	
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//virtual 
	bool 	MakeFitX(int index, const string &strDataLabel, vector& vX, vector& vFitX, TreeNode trOp, const tagFitResultCurveDataOptions& fitOptions);
	//virtual 
	bool 	MakeFitX(int index, const string &strDataLabel, matrix& mXs, matrix& mFitXs, TreeNode trOp, const tagFitResultCurveDataOptions& fitOptions);
	//virtual 
	bool 	MakeFitY(TreeNode &trOp, const matrix& mFitXs, matrix& mFitYs, int index = 0);
	///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	/*
	//virtual 
	int    	GetPictureNumForOneData(TreeNode& trOp = NULL, int nDataIndex = 0, int nGraphIndex = 0);
	*/
	//virtual 
	int    	GetReportGraphTableRowNum(TreeNode& trOp, int nGraphIndex = 0, bool bSkipPlotInOneGraphNode = true);
	int 	GetReportGraphTableColNum(TreeNode& trOp, int nGraphIndex = 0, bool bSkipPlotInOneGraphNode = true);
	///end REPORT_GRAPHS_ARRANGEMENT
	
	/// Iris 02/27/2007 FIX_ONLY_SHOW_ONE_GRAPH_FOR_MULTI_DEP_FUNC
	string 	GetReportGraphLabel(TreeNode& trOp, int nGraphIndex, int nPicRow, int nPicCol);
	int    	GetTotalNumPictureForOneGraphType(TreeNode& trOp, int nGraphIndex = -1);
	void	UpdateImageNodePlottingInfo(TreeNode& trOp, TreeNode& trPlotInfo, int nGraphIndex, int nDataIndex, int nPicIndex);
	///end FIX_ONLY_SHOW_ONE_GRAPH_FOR_MULTI_DEP_FUNC
	
	///// ML 1/26/2005 CUSTOM_TABLE_TO_GRAPH
	//// virtual
	//BOOL	getCustomTableThemeName(string &strThemeName, TreeNode &trOp, int nCustomIndex = 0);
	// virtual
	/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
	//int		getTableIdForGraph(string *pstr, TreeNode& trOp);
	/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
	/// end PROGRAMMATICALLY_PUTTING_A_REPORT_TABLE_INTO_A_GRAPH
	//virtual 
	///Arvin 12/04/06 ADD_CONF_PRED_BANDS_FOR_MR
	//bool	ConstructCurvesAndGraphs(TreeNode &trOp, int index, int nTotalNumData, LPCSTR strDataLabel, vector &vX, vector & vY, matrix &mXs, FitParameter *psFitParameter, RegStats *psRegStats, RegCalcInternal *psReg, DWORD dwPlotObjUID, int nMultiplicity = 1, matrix& mYs = NULL);  /// Iris 2/15/06 QA70-8461 v8.0365 INCLUDE_RPLICA_FOR_FITTING
	///Arvin 12/12/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	//bool	ConstructCurvesAndGraphs(TreeNode &trOp, int index, int nTotalNumData, LPCSTR strDataLabel, vector &vX, vector & vY, matrix &mXs, FitParameter *psFitParameter, RegStats *psRegStats, RegCalcInternal *psReg, DWORD dwPlotObjUID, int nMultiplicity = 1, matrix& mYs = NULL, vector& vSerr = NULL);  /// Iris 2/15/06 QA70-8461 v8.0365 INCLUDE_RPLICA_FOR_FITTING
	///Arvin 06/07/07 CENTRALIZE_FITTING_RESULT_LABELS as max's suggestion
	//bool	ConstructCurvesAndGraphs(TreeNode &trOp, int index, int nTotalNumData, LPCSTR strDataLabel, vector &vX, vector & vY, matrix &mXs, FitParameter *psFitParameter, RegStats *psRegStats, RegCalcInternal *psReg, DWORD dwPlotObjUID, int nMultiplicity = 1, matrix& mYs = NULL, vector& vSerr = NULL,  vector& vWeights = NULL);  /// Iris 2/15/06 QA70-8461 v8.0365 INCLUDE_RPLICA_FOR_FITTING
	bool	ConstructCurvesAndGraphs(TreeNode &trOp, int index, int nTotalNumData, LPCSTR strDataLabel, vector &vX, vector & vY, matrix &mXs, FitParameter *psFitParameter, RegStats *psRegStats, RegCalcInternal *psReg, DWORD dwPlotObjUID, int nMultiplicity = 1, matrix& mYs = NULL, vector& vSerr = NULL,  vector& vWeights = NULL, LPCSTR lpcsDataLabelCurves = NULL);  /// Iris 2/15/06 QA70-8461 v8.0365 INCLUDE_RPLICA_FOR_FITTING
	///end CENTRALIZE_FITTING_RESULT_LABELS
	///end ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	///end ADD_CONF_PRED_BANDS_FOR_MR
	/// Iris 1/17/06 CLEANUP_NLFITSESSION_STRUCT
	//virtual bool 	MakeFitXY(const TreeNode& trOp, const vector& vX, const vector& vY, int& nRow, int& nCol, vector& vFitX, vector& vFitY);
	//virtual bool	MakeFitZ(const TreeNode &trOp, const vector& vFitX, const vector& vFitY, matrix& mat, int index = 0);
	///End CLEANUP_NLFITSESSION_STRUCT
	//virtual 
	int		ReportGetPlotTypeFromGraphIndex(int nGraphIndex); 
	
	//virtual 
	bool 	IsSourceDataPlotInReport(int nGraphIndex = 0);  /// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
	
	//virtual
	string GetGraphTemplate(int nGraphIndex = 0);
	/// Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
	//virtual	
	bool	ParamsFromGUItoOperation(TreeNode& trOperation);
	///end ADD_PARAMETER_SETTING_TO_THEME
	///Arvin 12/07/06 IMPROVE_SURFACE_FIT_RESIDUAL_CONTOUR
	bool UpdateResidualContourLevels(GraphLayer& gl, int index = 0);
	bool SetupPlotDetails(const TreeNode& trOp, GraphLayer& gl, int nFittedPlot, int nNumPlots = 1, int nGraphIndex = 0, int nDataIndex = 0, bool bIsSourceGraph = false, bool bUpdateExistedReportGraph = false); 
	int	ReportGraphGetRescaleOption(TreeNode& trOp, int nGraphIndex = 0);
	///end IMPROVE_SURFACE_FIT_RESIDUAL_CONTOUR	
	
	//virtual	
	/// Hong 09/03/08 QA80-12130 NLFIT_SESSION_SUPPORT_SEPARATE_FIT
	//bool AddRegStatsToReportTree(TreeNode& trOp, int index, const string &strDataLabel, int nTotalNumData, const vector<string> &vstrFactors, const RegStats &sRegStats);
	bool AddRegStatsToReportTree(TreeNode& trOp, int index, const string &strDataLabel, int nTotalNumData, const vector<string> &vstrFactors, const RegStats &sRegStats, int* pnSetIndex = NULL);
	/// end NLFIT_SESSION_SUPPORT_SEPARATE_FIT
	
	//virtual
	/// Iris 5/19/2008 RENAME_OLD_FUNCTION_AND_MOVE_TO_SUIT_PLACE
	//void 	OnAfterAddOneDataStatsResultsToReportTree(TreeNode& trOp, int index);
	void 	OnAfterAddParamtersSummaryTable(TreeNode& trOp, int index);
	///end RENAME_OLD_FUNCTION_AND_MOVE_TO_SUIT_PLACE

	///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
	//virtual
	bool	IsAddMaskedOrMissingDataTableForMultiIndep(vector& vX, matrix& mMultiIndep);
	///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
	
	///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	//virtual 
	bool 	UpdateInputBranch(TreeNode& trOp);
	///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	///Arvin 04/17/07 v8.0602 FIT_MATRIX_HISTOGRAM_PLOT
	string	GetOneResultCurvesTableTagName(int nGraphIndex);
	///end FIT_MATRIX_HISTOGRAM_PLOT
	///Arvin 04/24/07 v8.0607 SURFACE_FIT_NEED_UPDATE_TROPERATION_BEFORE_RUNNING_CHANGE_PARAM_AND_RECALCULATE
	void	OnBeforeCalculations(TreeNode& trOperation, int nExeMode);
	///end SURFACE_FIT_NEED_UPDATE_TROPERATION_BEFORE_RUNNING_CHANGE_PARAM_AND_RECALCULATE
	
	virtual void	InitFitSessionPointer(TreeNode &trOp);
	///Cheney 2007-7-30 ADD_NEW_FUNC_TO_SUPPORT_PFM_LOAD_FDF
	virtual bool	LoadFDFtoTree(LPCSTR lpcszFuncName);
	virtual void	UpdateFDFTreeFromThemeOrChangeFunc(bool bOpenDlg);
	///end ADD_NEW_FUNC_TO_SUPPORT_PFM_LOAD_FDF
	
	///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME	
	//virtual
	void	ThemeUpdateLastUsed(LPCSTR lpcszClassName, TreeNode& tr, bool bThemesTree = false);
	///end CORRECT_LOGIC_OF_LOADING_THEME
	
	///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//virtual 
	string GetSourcePageName(TreeNode& trOp, Datasheet& ds = NULL);
	///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	///Cheney 2007-9-6 FINDZ_NODE_SHOULD_PREPARED_WHEN_CHANGE_PARAM	
	//virtual
	BOOL	UpdateCalibrationBranch(TreeNode& trOperation); 
	///end FINDZ_NODE_SHOULD_PREPARED_WHEN_CHANGE_PARAM
	
	BOOL	IsXOPFuncReady(const TreeNode& tr); ///Cheney 2007-9-10 XOP_NEED_SUPPORT_PFM
	
	///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	//virtual  
	void	PrepareMissingOrMaskedTable(TreeNode& trTable, TreeNode& trRows, 
				LPCSTR lpcszTagRows, int idRows, TreeNode& trMain, LPCSTR lpcszTagMain, int idMain,
				LPCSTR lpcszTableLabel, TreeNode& trCols, LPCSTR lpcszTagCols, int idCols);
	
	//virtual  
	int		GetMissingDataAndIndex(const DataRange& dr, LPCSTR lpcszXDataLabel, DWORD dwRules, int index,
				vector<int>& vintRows, vector& vMain, vector& vX, matrix& mMultiIndep, vector& vWeight, 
				vector& vYIndep, vector<int>& vintCols);
				
	//virtual	 
	bool	AddColsIndexToMissingDataTable(TreeNode& trCol, const vectorbase& vData, int nBaseID, LPCSTR lpcszRowLabel, int* pRowStart = NULL);
	///end MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//virtual	 
	int	GetReportOutPutDestination(const TreeNode& trInput);
	//virtual	 
	/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
	//int	GetDataOutPutDestination(const TreeNode& trOutput, string& strReportBook, Worksheet* pwksReport);
	///Sophy 6/2/2008 ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
	//int	GetDataOutPutDestination(const TreeNode& trOutput, const TreeNode& trInput, string& strReportBook, Worksheet* pwksReport);
	int	GetDataOutPutDestination( TreeNode& trOp, const TreeNode& trOutput, const TreeNode& trInput, string& strReportBook, Worksheet* pwksReport);
	///end ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
	/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
	///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	
	///Arvin 11/20/07 QA70-10708 CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
	//virtual
	bool CheckLoadOperation(TreeNode& trOperation, int nCurrentOperationVersion);
	///end CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
	
	/// Jack 12/19/2008 QA80-12329 MULTI_INDEP_DEPS_BAND_CALCULATION
	bool CalcConfOrPredBounds(TreeNode &trOp, bool bConf, double dBoundLevel, vector& vLower, vector& vUpper, matrix& mIndeps, vector &vFitY, GraphLayer& grLayAppar, FitParameter* psFitParameter, RegStats &stRegStats, RegCalcInternal* pstReg, vector& vSE, int index, int iDep);
	/// End MULTI_INDEP_DEPS_BAND_CALCULATION


	///Arvin 01/11/08 QA70-10923 CALC_CONFIDENCE_AND_PREDICTION_BANDS
	//virtual
	bool 	CalcConfOrPredBounds(TreeNode &trOp, bool bConf, double dBoundLevel, vector& vLower, vector& vUpper, vector& vIndep1, vector &vFitY, GraphLayer& grLayAppar, FitParameter* psFitParameter, RegStats &stRegStats, RegCalcInternal* pstReg, vector& vSE = NULL, vector& vIndep2 = NULL, int index = 0);
	///end CALC_CONFIDENCE_AND_PREDICTION_BANDS
	
	///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	DWORD GetOutputOptions(const TreeNode& trOp);
	bool GetCombinedMinMaxAndBinNumber(TreeNode & trOp, double& dMin, double& dMax);
	///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL	
	
	//virtual
	bool	InitOutputGUIManagerPointer(const TreeNode& trGUI); /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

	virtual bool	IsReportComplexInputDataTable(TreeNode& trOp); /// Iris 4/25/2008 NANOSIZER_REPORT_COMPLEX_INPUT_DATA_WITH_WEIGHT_INFO
	/// Sophy 5/07/2008 QA80-10934-P5 v8.0857 FIX_BUG_SURFACE_AND_MATRIX_FIT_WRONG_DEFAULT_SHEETNAME
	virtual TreeNode GetSheetNameNode( TreeNode& trBookSheetBranch, int nIndex = 0);
	
	//	virtual 
	void SetFindXYOutputSheetDefaultName( TreeNode& trGUI);
	/// End FIX_BUG_SURFACE_AND_MATRIX_FIT_WRONG_DEFAULT_SHEETNAME
	
	/// Hong 09/05/08 v8.093cc FITNL_USING_NEW_NLFSESSION
	void			InitNLFitCurvePointer(TreeNode &trOp);
	NLFCurvesBase* 	GetNLFCurvePointer();
	/// end FITNL_USING_NEW_NLFSESSION
	///---Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS
	virtual	BOOL	LabTalkTreeAccess(LPSTR lpVar, LPSTR lpArg, LPVOID lpValue, WORD msg);
	virtual	BOOL	MakeLabTalkTree(TreeNode& trLT);
	///---END NLFIT_LABTALK_TREE_ACCESS
	
	/// Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	// virtual 
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	//uint		GetPlotCtrl();
	uint		GetPlotCtrl(TreeNode& trOp);
	//------
	/// end NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	///Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	virtual void	FilterDataRulesForPlot(DWORD& dwDataRules);
	///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING

	///Sophy 7/7/2009 v8.1058 QA80-12613-P6 FITCURVE_Y_COLUMN_FORMAT_MUST_BE_CONSISTENT_WITH_SOURCE_DATA_IN_3D_FITTING
	bool UpdateOneYColumnFormat(TreeNode& trCol, int nIndex);
	///end FITCURVE_Y_COLUMN_FORMAT_MUST_BE_CONSISTENT_WITH_SOURCE_DATA_IN_3D_FITTING
	
	/// Iris 7/29/2009 QA80-14029 FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM
	//virtual 
	void	SetupPlotsOnRecalculate(GraphLayer& gl, int nGraphIndex);
	///end FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM

private:
	bool m_bUseFitSession;//CPY 5/17/06 NLFIT_CLICK_OK_FAILED_CONVERGE
	
	/// Iris 01/30/2007 IMPROVE_NLSF_SPEED
	int		m_nNumberIndepVariables;
	int		m_nNumberDepVariables;
	///END IMPROVE_NLSF_SPEED
	
	vector<bool>	m_vbFitConverged;
	vector<bool>	m_vbShared;
	vector<bool>	m_vbFixed;
	///Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING
	int				m_nMaskedOrMissingDataRowStart;
	///end FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING
	///Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
	/////Cheney 2007-4-2 ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA
	//bool			m_bHasMissing;
	//bool			m_bHasMasked;
	/////end ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA
	///end ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
	///Cheney 2007-4-4 ADD_FOOTNOTE_FOR_FIT_STATUS_AS_LARRY_SUGGEST
	string			m_strFitStatus;
	///end ADD_FOOTNOTE_FOR_FIT_STATUS_AS_LARRY_SUGGEST
	
	///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	vector			m_vParamValues;
	vector			m_vParaLowerBounds;
	vector			m_vParaUpperBounds;
	vector<bool>	m_bFixed;
	vector<bool>	m_vbpbExclusiveLower;
	vector<bool>	m_vbOnLowerBounds;
	vector<bool>	m_vbpbExclusiveUpper;
	vector<bool>	m_vbOnUpperBounds;
	vector<int> 	m_vnSignDigit;///Jasmine 10/17/07 MISSING_SIGN_DIGITES
	///end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	///Cheney 2007-4-24 CLEAN_UP_FDF_TREE_LOAD	
	Tree			m_trFDF;
	///end CLEAN_UP_FDF_TREE_LOAD
	
	//--- CPY 2/16/10 QA81-15106 CHANGE_PARAM_BY_SCRIPT
	bool isFDFTreeValid();
	//---
	
	//------ Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
	vector			m_vContourLevelInfo;
	//------
		
	/// Hong 09/05/08 v8.093cc FITNL_USING_NEW_NLFSESSION
	NLFCurvesBase* 	m_pNLFCurves;
	/// end FITNL_USING_NEW_NLFSESSION
	
	///---Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS
	DWORD 			m_dwOption;
	///---END NLFIT_LABTALK_TREE_ACCESS
public:
	/// YuI 11/09/06 SOME_REDESIGN_OF_NLFIT_FOR_MODAL
	//	//---- CPY 4/23/05 OK_ON_BAD_FIT_DO_NOT_CLOSE_DIALOG
	//	void	SetFitSession(NLFitSession* pFitSession);
	//	//----
	/// SOME_REDESIGN_OF_NLFIT_FOR_MODAL
	/// Iris 06/16/06 SET_BACK_FIT_POINTER_FOR_BAD_FIT
	/// YuI 11/09/06 SOME_REDESIGN_OF_NLFIT_FOR_MODAL
	//	NLFitSession* GetFitSession(bool bTransfer);  
	NLFitSession* GetFitSession();
	/// SOME_REDESIGN_OF_NLFIT_FOR_MODAL
	///End SET_BACK_FIT_POINTER_FOR_BAD_FIT
	
	/// Iris 8/09/06 FIND_XY_FOR_PR
	//virtual 
	///Cheney 2007-6-19 ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	//bool 	GetYFromX(const vector& vx, vector& vy, int nOuputIndex = 0, TreeNode& trOp = NULL, const matrix& mXs = NULL);
	bool 	GetYFromX(const vector& vx, vector& vy, int nOuputIndex = 0, TreeNode& trOp = NULL, const matrix& mXs = NULL, int nPeaks = 1, vector& vParams = NULL);
	///end ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	///end FIND_XY_FOR_PR
	
	///Arvin 1/04/06 FIND_Z_FROM_XY
	bool 	GetZFromXY(const vector& vx, const vector& vy, vector& vz, int nOuputIndex = 0, TreeNode& trOp = NULL, const matrix& mXs = NULL);
	string	GetResultCurveSheetName(TreeNode& trOperation, int nIndex = 0, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);
	string GetResultCurveBookName(TreeNode& trOperation, int nDataIndex = 0, int nOption = -1, bool bSeparateSheetForDataset = false);
	bool IsOutputSeparateCalibrationSheet(const TreeNode& trOp, int nXfromY);
	///end FIND_Z_FROM_XY
	//virtual 
	string	GetResultCurveBookShortName(TreeNode& trOperation, int nIndex = 0, int nOption = -1); /// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	
	/// ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	#ifdef		__NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
	// virtual
	void	GetEscapedMainDataString(TreeNode &trOp, string &str, int indexLT, bool bInputTable = false, char cType = 0, char cXYW = 0);
	//virtual bool IsOutputSeparateResidualCurveSheet();  ///Iris 9/26/06 no need overload here
	#endif //__NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
	
	///Arvin 10/31/06 FITTING_RESIDUALS_HISTOGRAM_PLOT_CENTRALIZED
	bool CalcAddStatsHistPlotData(TreeNode& trOp, int index, FitParameter* psFitParameter, matrix &mYs, matrix &mXs, const vector<string> &vstrFactors, const vector &vWeights, string& strDataLabel);
	bool CalcAddStatsHistPlotData(TreeNode& trOp, int index, const vector<string> &vstrFactors, const vector &vWeights, string& strDataLabel);
	///end FITTING_RESIDUALS_HISTOGRAM_PLOT_CENTRALIZED
	
	///Arvin 12/11/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	//bool GetOneTypeResidualData(const TreeNode &trOp, const vector& vX, const vector& vRegularRes, vector& vResidual, int index = 0, int nPeak = 0, int nResType = REGULAR_RESIDUAL, vector &vY = NULL, vector &vWeights = NULL, matrix &mXs = NULL);
	bool GetAllTypeResidualData(const TreeNode &trOp, const vector& vX, const vector& vRegularRes, vector& vStand, vector& vStud, vector& vStudDel, int index = 0, int nPeak = 0, vector &vY = NULL, vector &vWeights = NULL, matrix &mXs = NULL);
	///end ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	
	/// Hong 01/24/08 QA80-10929 LT_NLFIT_SUPPORT_SOUURCE_GRAPHPAGE_PREVIEW
	// virtual
	bool EnableSourceGraphPreview();
	/// end LT_NLFIT_SUPPORT_SOUURCE_GRAPHPAGE_PREVIEW
	
	/// Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	// Hong, move from private to protected to be consistent with base class
	/// Hong 05/30/08 QA80-11632 FIX_SURFACE_FIT_REPORT_FIT_CURVE_FAIL_CORRECT_RESCALE
	virtual 	bool IsFitCurveFollowSourcePlotType();
	/// end FIX_SURFACE_FIT_REPORT_FIT_CURVE_FAIL_CORRECT_RESCALE
	/// end SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	
	//------ Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
	//virtual
	int	GetDataSourcePlotType(int nGraphIndex);
	
	bool	SetupSourceDataPlot(BOOL bResiduleGraph, DataPlot &dp, vector *pZ = NULL, int nSteps = 16);
	
	bool	SetupFitCurvesPlot(DataPlot &dp, vector &vZ);
	
	bool	SetupResidualPlot(DataPlot& dp, vector& zz, double irl = 20, double orl = 5, int nInnersteps = 8, int nOutSteps = 20);
	
	//virtual
	bool	SetupPlotsAfterRescale(GraphLayer &gl, int nGraphIndex);
	//------ End SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
	
private:	
	// virtual
	string	getClassNameForCustomTableTheme()
	{
		return STR_FITTEROPERATION_CLASS_FITNL;
	}
	bool getCategoryList(string &strCateList, char chDelimiter = '|')
	{
		vector<string>	vsNLSFCategory;
		
		if(!nlf_get_section_keys_and_values("Category", vsNLSFCategory))
		{
			strCateList.Empty();
			return false;
		}
		strCateList.SetTokens(vsNLSFCategory, chDelimiter);
		return true;
	}
	///Arvin 1/04/06 FIND_Z_FROM_XY
	bool	addAdditionalCustomTables(TreeNode &trOp, int index, int nNumData);
	bool    setFindZTable(TreeNode &trCustom, string &strInputXColLabel, int nInputXColType, string &strInputYColLabel, int nInputYColType, string &strOutColLabel, int nOutputColType, string &strValueToStore);
	bool	addFindZTable(TreeNode &trOp, bool bYfromX, int index, int nNumData);
	///end FIND_Z_FROM_XY
	/// ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION
	bool 	getCategoryFuncNamesAll(TreeNode& trOperation, string& strCategory, string& strFunction, vector<string>& vsFilterList);
	bool	IsSpecFit(const TreeNode& trOp, string *pstrClassName = NULL, string *pstrOption = NULL, string *pstrName = NULL, string *pstrCat = NULL, int *pnOption = NULL);
	/// end INVOKING_OPERATION_FROM_XFUNCTION
	
	/// ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	#ifdef		__NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
	/// Iris 4/28/2008 NANOSIZER_REPORT_COMPLEX_INPUT_DATA_WITH_WEIGHT_INFO
	//void	updateInputDataTable(TreeNode &trInputTable, int index, int numData, DWORD dwRules);
	void	updateInputDataTable(TreeNode &trInputTable, int index, int numData, DWORD dwRules, bool bIsXYZData);
	///end NANOSIZER_REPORT_COMPLEX_INPUT_DATA_WITH_WEIGHT_INFO
	TreeNode	makeInputDataTableVarRow(TreeNode &trInputTable, int indexSet, int iWithinSet, int iWithinDepOrIndep, bool bDep, LPCSTR lpcszVarName, int numData, int nTotalPerSet);
	///Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
	//bool	getSetDataString(string &str, int indexSet);
	/////end MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
	bool	updateMaskedOrMissingDataTables(TreeNode& trOp, DataRange& dr, int index, StringArray &vstrDepVarNames, StringArray &vstrIndepVarNames,
													int nNumData, int numSubRanges, DWORD dwRules, LPCSTR lpcszDataLabel, bool bMissingData);
	bool	setOneMaskedOrMissingTable(DataRange& dr, TreeNode &trTable, int index, StringArray &vstrDepVarNames, StringArray &vstrIndepVarNames,
												DWORD dwRules, LPCSTR lpcszDataLabel, bool bMissingData, bool bCreateTable);
	#endif		// __NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
	/// end NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	
	//void    createSetupResultMatrix(matrix& matFit, const vector& vFitX, const vector& vFitY, int nRow, int nCol, const vector& vX, const vector& vY, const matrix& matData, FitParameter *psFitParameter);
	//bool 	reportResidualMatrixData(MatrixLayer& ml, const vector& vX, const vector& vY, const matrix& matData, int nRow, int nCol, FitParameter* psFitParameter);
	void    createSetupResultMatrix(matrix& matFit, const vector& vFitX, const vector& vFitY);
	///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
	//bool 	reportResidualData(TreeNode& trOp, int index, int nTotalNumData);
	bool 	reportXYZResidualData(TreeNode& trOp, int index, int nTotalNumData);
	///Arvin 04/17/07 v8.0602 FIT_MATRIX_HISTOGRAM_PLOT
	//bool 	reportMATResidualData(TreeNode& trOp);
	bool 	reportMATResidualData(TreeNode& trOp, int index, int nTotalNumData);
	///END FIT_MATRIX_HISTOGRAM_PLOT
	///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
	string 	getXYMapInfo(const vector& vFitX, const vector& vFitY, int nRow, int nCol);
	
	void appendFitFootnoteToParamTable(TreeNode& trOp, int index, int nTotalNumData);
	///Cheney 2007-4-4 ADD_FOOTNOTE_FOR_FIT_STATUS_AS_LARRY_SUGGEST
	void appendFitFootnoteToStatsTable(TreeNode& trOp, int index, int nTotalNumData);
	///end ADD_FOOTNOTE_FOR_FIT_STATUS_AS_LARRY_SUGGEST
	
	/// Iris 12/30/2006 v8.0534 CORRECT_DERIVED_PARAMS_ORDER_FOR_REPLICA_CASE
	virtual bool insertDerivedParamsNames(vector<string>& vstrParameterNames, vector<string>& vsDerivedParamNames, bool bIncPostifx, vector<bool>& vnTarget, int index);
	///end CORRECT_DERIVED_PARAMS_ORDER_FOR_REPLICA_CASE
	
	///Kyle 08/10/2009 QA80-14077 ADD_PARAMETER_UNIT_TO_FITTING_REPORT
	virtual bool insertDerivedParamsUnits(vector<string>& vstrParameterUnits, vector<string>& vsDerivedParamUnits, vector<bool>& vnTarget, int index);
	///End ADD_PARAMETER_UNIT_TO_FITTING_REPORT
	
	/// Iris 2/25/2007 v8.0570 SUPPORT_INDEP_FIT_MODE
	bool	isSepFit(TreeNode& trOp);
	bool	doOneFit(TreeNode& trOp, DataRange& dr, bool bIsXYZData, int nExeMode, DWORD dwExecCntrl, int nNumData, int numSubRanges, int nNumDataToFit, int nDataFrom = -1, bool bSepFit = false);
	///end SUPPORT_INDEP_FIT_MODE
	///Arvin 05/08/07 QA70-9498 SCALE_PARAMETER_ERRORS_WITH_CHI_SQR
	//BOOL 	isParamErrorNeedScale(const TreeNode& trOp, int nSetIndex = 0);
	BOOL	isVarCovarMatrixNeedScale(const TreeNode& trOp, int nSetIndex = 0);
	void 	getCovAndCorrMatrix(const TreeNode& trOp, matrix& matCov = NULL, matrix& matCorr = NULL);
	///end SCALE_PARAMETER_ERRORS_WITH_CHI_SQR
	 ///Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING
	int getRowStartForMaskedOrMissingData(){return m_nMaskedOrMissingDataRowStart;}
	void setRowStartForMaskedOrMissingData(int nMaskedOrMissingDataRowStart){m_nMaskedOrMissingDataRowStart = nMaskedOrMissingDataRowStart;}
	 ///end FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING
	 //Cheney 2007-4-2 IF_SHARE_PARAMETERS_ADD_HINTS_IN_FOOTNOTE
	bool addHintOnFootnoteForShareParams(TreeNode& trFootNote);
	///end IF_SHARE_PARAMETERS_ADD_HINTS_IN_FOOTNOTE
	///Cheney 2007-4-4 SHOW_LB_UB_IN_REPORT_SHEET
	
	//------ Folger 11/06/08 QA80-12536 v8.0966 LOWER_AND_UPPER_BOUNDS_FAILS_TO_REPORT_IN_PA
	/*
	//------ Folger 08/18/08 QA80-12036 FIX_BOUNDS_MISSING_IN_REPORT_SHEET_FOR_REPLICA_FIT
	//bool addOneDataLBUBToParametersTable(TreeNode& trOp, vector<string>& vstrFactors, vector<string>& vsParamNames, vector<string>& vsParamNamesPostfix, int nDataFrom = 0);
	bool addOneDataLBUBToParametersTable(TreeNode& trOp, vector<string>& vstrFactors, vector<string>& vsParamNames, vector<string>& vsParamNamesPostfix, int nDataFrom = 0, int nNumMultiplicity = 0);
	//------
	///end SHOW_LB_UB_IN_REPORT_SHEET
	*/
	virtual	bool addOneDataLBUBToParametersTable(TreeNode& trOp, vector<string>& vstrFactors, vector<string>& vsParamNames, vector<string>& vsParamNamesPostfix, int nDataFrom = 0, int nNumMultiplicity = 0);
	//------ End LOWER_AND_UPPER_BOUNDS_FAILS_TO_REPORT_IN_PA
	
	///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	bool getUserSettingFromGUI(int nDataIndex);
	bool setUserSettingFromGUI();
	///end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	
	///Cheney 2007-4-24 CLEAN_UP_FDF_TREE_LOAD	
	bool loadFDFTree(TreeNode& trFDF, LPCSTR lpcszFuncName, string* lpstrCategory = NULL, int* pnFolder = NULL, DWORD dwCtrl = 0);
	///end CLEAN_UP_FDF_TREE_LOAD
	
	virtual		///------ Folger 09/25/09 LINEAR_CONSTRAINTS_NOT_WORK_WHEN_RUN_PA_IN_SCRIPT_MODE
	bool	setNLFitSettings(TreeNode& trOp);  /// Iris 06/15/2007 v8.0642 FIX_NOT_SET_FIT_SETTINGS_FROM_GUI_TO_NLFIT_WHEN_SEL_MENU_THEME

	///Cheney 2007-6-19 ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	//it only for GetYFromX, so no need to get derived parameters
	//so when pass trParams, it should no derived parameters
	int		getFitParamsMultiPeaks(vector& vParamsCurrentPeak, vector& vParams, int nParamBegin, int nParamEnd, TreeNode& trParams);
	///end ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	bool 	setAutoInitAndLinearConstrtoOperationTree(TreeNode& trOp); 	///Cheney 2007-7-16 SHOULD_SHARE_CODE_BETWEEN_NLFITSPLITTER_AND_FITNL_ABOUT_AUTOINIT_AND_LINEAR_CONSTRAINT
	bool	updateSepcInfo(TreeNode& trOp);	///Cheney 2007-7-17 SHOULD_UPDATE_SPECI_INFO_WHEN_THEME_LOAD_OR_FUNC_CHANGE_IF_IS_SPECI_FIT
	void	updateOutputSettingFor3DFitting(TreeNode& trOperation);  ///Cheney 2007-8-30 QA70-10290-sug4 FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
	bool	isDataFromMatrix(GraphLayer& gl); ///Cheney 2007-9-13 SUPPORT_FIT_MATRIX_FROM_GRAPH	
	///Cheney 2007-11-2 QA70-10626 ADD_REPLICA_INFO_IN_REPORT_TABLE
	
	//------ Folger 11/28/08 v8.0980 CLEAN_UP_REPLICA_FITTING_JUDGEMENT
	/*
	/// Hong 12/26/07 QA80-10499 FIX_MULTIDATASET_LOST_THEME_VALUE_WHEN_FROM_MRU_WITHOUT_DIALOG_EXCEPT_FIRST_ONE
	//bool isReplicaFit(const TreeNode& trOp);
	bool isReplicaFit(const TreeNode& trOp, bool bCheckHasReplica = true);
	*/
	bool	isReplicaFitSupported(const TreeNode& trOp);
	///Jasmine 06/18/09 VIRTUAL_FOR_NANOSIZER
	virtual bool	isReplicaFit(const TreeNode& trOp);
	///End VIRTUAL_FOR_NANOSIZER
	//------ End CLEAN_UP_REPLICA_FITTING_JUDGEMENT
	
	/// end FIX_MULTIDATASET_LOST_THEME_VALUE_WHEN_FROM_MRU_WITHOUT_DIALOG_EXCEPT_FIRST_ONE
	bool addReplicaInfoOnStatsTable(TreeNode& trOp, int nIndex, const string& strDataLabel, int nNumData);
	///end ADD_REPLICA_INFO_IN_REPORT_TABLE
	
	bool addDerivedParamsInfoOnFootnote(TreeNode trFootNote); ///Cheney 2007-11-6 QA70-10659 ADD_LCL_UCL_FOR_DERIVED_PARAMS
	bool hideReplicaRelatedNode(TreeNode& trStatistics); ///Cheney 2007-11-16 ONLY_NLFIT_XYFITTING_SHOW_REPLICA_RELATED_CHECK_BOX
		
	///Sophy 6/23/2008 FIX_MATRIX_FIT_RUNTIME_WHEN_ACTIVE_OUTPUT_PANEL
	string	getSourcePageName(  TreeNode trOp, TreeNode trInput, int nFitType );
	///end FIX_MATRIX_FIT_RUNTIME_WHEN_ACTIVE_OUTPUT_PANEL
	
	bool	isNormalFit(int nFitOption); /// Iris 8/15/2008 QA80-12025 TO_FIX_DOUBLE_MEANING_FOR_nOption_IN_FITNL
	
	/// Hong 09/05/08 v8.093cc FITNL_USING_NEW_NLFSESSION
	void	CleanupNLFitCurve(LPCSTR lpcszMsg);
	DWORD	getPlotUID(TreeNode& trOp, int nDataset = 0);
	/// end FITNL_USING_NEW_NLFSESSION
	
	//------ Folger 10/14/08 WRONG_NLF_CURVES_CLASS_IN_PA_MAKES_WRONG_REPORT
	virtual	NLFCurvesBase*	createNLFCurvePointer(TreeNode& trOp);
	//------
	
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	bool	checkUpdateFDFTree(LPCSTR lpcszFunc);
	//------
	
	void 	setupResidualLimit(GraphLayer& gl); /// Iris 7/29/2009 QA80-14029 FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM

protected:
	/// Iris 4/12/06 NLFITSESSION_POINTER_FOR_NORMAL_FIT_OR_PFM
	//NLFitSessionBase	m_FitSession;
	//NLFitSessionBase*	m_pFitSession;
	NLFitSession*	m_pFitSession;
	///End NLFITSESSION_POINTER_FOR_NORMAL_FIT_OR_PFM
};

#endif //_NLFITTEROPERATION_H
